% Author: Layla S. Mayboudi
% 2021-05-27
% This code code creates a transient thermal PDE model and plots the geometry 
% and heat flux flow diagrams.

clc; clf; close all; clear all;
thermalmodel = createpde('thermal','transient');
g = @squareg;
geometryFromEdges(thermalmodel,g);
figure(1);
pdegplot(thermalmodel,'EdgeLabels','on')
xlim([-1.2 1.2]); ylim([-1.2 1.2]); axis equal; 
title('Geometry with Edge Labels Displayed');
thermalProperties(thermalmodel,'ThermalConductivity',100, ...
                               'MassDensity',7800, ...
                               'SpecificHeat',500);
                           thermalBC(thermalmodel,'Edge',[1 3 4],'HeatFlux',0);
thermalBC(thermalmodel,'Edge',2,...
                       'ConvectionCoefficient',5000, ...
                       'AmbientTemperature',25);
       thermalIC(thermalmodel,25);
thermalIC(thermalmodel,100,'Edge',1);
generateMesh(thermalmodel);

tlist = 0:1000:200000;
thermalresults = solve(thermalmodel,tlist)
v = linspace(-1,1,11);
[X,Y] = meshgrid(v);

[qx,qy] = evaluateHeatFlux(thermalresults,X,Y,1:length(tlist));
tlist(25)
figure(2);
quiver(X(:),Y(:),qx(:,25),qy(:,25));
xlim([-1,1]); axis equal;
title('Heat Flux');